% Script to generate figure 3

% This file is part of Code and Data for the numerical experiments in 
% "Frequency-Based Reduced Models from Purely Time-Domain Data via Data Informativity"
% Copyright (C) 2023 Michael S. Ackermann
% All rights reserved.
% License: BSD 2-Clause License (see COPYING)

%% Load data
load RandEx1.mat
load ../data/ReproduceFig3Data.mat
%% set up
K_vec = [10,20,30,70,150];
num_trial = length(K_vec);
H_true = @(s) C*((s*eye(length(A))-A)\B);

w = 10^-2;
z = exp(1i*w);
s_W_vec = NaN(num_trial,1);
Hs_vec = NaN(num_trial,1);

%% Calculate transfer function values for different K
for i = 1:num_trial
    clear opts
    opts.der_order = 0;
    opts.n = 100;
    opts.num_windows_keep = 10;
    opts.num_windows = K_vec(i);
    [Hz,nstd_Hz,cond_nums,residuals] = CalculateTFVals(U,Y,z,opts);
    s_W_vec(i) = abs(nstd_Hz*Hz); %unnormalize
    Hs_vec(i) = Hz;
end

%% plot
load ColorMat.mat

param = exp(1i*2*pi*(0:100)/100);

figure;
axis equal
abs_err_vec = NaN(num_trial,1);
leg = cell(num_trial+1,1);
Hs_true = H_true(z);
plot(Hs_true,'k.','MarkerSize',30)
leg{1} = '$H_0(\sigma)$';
hold on
plot(s_W_vec(1)*param + Hs_vec(1),'Color',ColorMat(1,:),'LineWidth',2)
abs_err_vec(1) = abs(Hs_true-Hs_vec(1));
leg{2} = strcat('$K = $',num2str(K_vec(1)));
for i = 2:num_trial
    plot(s_W_vec(i)*param + Hs_vec(i),'Color',ColorMat(i,:),'LineWidth',2)
    abs_err_vec(i) = abs(Hs_true-Hs_vec(i));
    leg{i+1} = strcat('$K = $',num2str(K_vec(i)));
end
for i = 1:num_trial
    plot(Hs_vec(i),'*','Color',ColorMat(i,:),'MarkerSize',10)
end


legend(leg,'Interpreter','latex')

max_abs_err = .5*10^(floor(log10(max(abs_err_vec)))+1);
max_abs_err_str = num2str(log10(max_abs_err));
ax = gca;
Default_TW = ax.TickLength;
Default_LW = ax.LineWidth;
ax.TickLength = Default_TW * 2;
ax.LineWidth = Default_LW * 2;
ax.FontSize = 20;
axis equal
xlim([real(Hs_true) - max_abs_err,real(Hs_true) + max_abs_err])
xticks([real(Hs_true) - max_abs_err,real(Hs_true),real(Hs_true) + max_abs_err])
xticklabels({strcat('$-10^{',max_abs_err_str,'}$'),'$0$',strcat('$10^{',max_abs_err_str,'}$')}')
ax.TickLabelInterpreter='latex';
xlabel('$Re(M_0)-Re(H_0(\sigma))$','interpreter','latex','fontsize',20)
ylabel('$Im(M_0)-Im(H_0(\sigma))$','interpreter','latex','fontsize',20)
ylim([imag(Hs_true) - max_abs_err,imag(Hs_true) + max_abs_err])
yticks([imag(Hs_true) - max_abs_err,imag(Hs_true),imag(Hs_true) + max_abs_err])
yticklabels({strcat('$-10^{',max_abs_err_str,'}$'),'$0$',strcat('$10^{',max_abs_err_str,'}$')}')


xlim([real(Hs_true) - max_abs_err,real(Hs_true) + max_abs_err])
xticks([real(Hs_true) - max_abs_err,real(Hs_true),real(Hs_true) + max_abs_err])
xticklabels({strcat('$-10^{',max_abs_err_str,'}$'),'$0$',strcat('$10^{',max_abs_err_str,'}$')}')
lgd = legend();
lgd.Location = 'EastOutside';




